#include "PhysicData.h"        
        
PhysicData::PhysicData(int iX, int iY, float fMasse, bool bBouge, bool bCollision)
: m_fMasse(fMasse), m_bBouge(bBouge), m_bCollision(bCollision)
{
    m_fX=(float)iX;
    m_fY=(float)iY;
    
    m_fRebond[0]=0.0;
    m_fRebond[1]=0.0;
    m_fRebond[2]=0.0;
    m_fRebond[3]=0.0;
    
    m_fVmaxX=600.0;
    m_fVmaxY=600.0;
    
    m_fFrot[0]=0.0;
    m_fFrot[1]=0.0;
    m_fFrot[2]=0.0;
    m_fFrot[3]=0.0;
    
    m_fVx=0.0;
    m_fVy=0.0;
    
    m_bBloque[0]=false;
    m_bBloque[1]=false;
    m_bBloque[2]=false;
    m_bBloque[3]=false;
    
    if (bBouge)
        m_pListeForces = new ListeChainee<Force>;
    else
        m_pListeForces = NULL;
 
    m_iX1=0;
    m_iY1=0;   
    m_iX2=0;
    m_iY2=0;
 
}

PhysicData::PhysicData(int iX, int iY, int iX1, int iY1, int iX2, int iY2, float fMasse, bool bBouge, bool bCollision)
: m_iX1(iX1), m_iY1(iY1), m_iX2(iX2), m_iY2(iY2), m_fMasse(fMasse), m_bBouge(bBouge), m_bCollision(bCollision)
{
    m_fX=(float)iX;
    m_fY=(float)iY;
    
    m_fFrot[0]=0.0;
    m_fFrot[1]=0.0;
    m_fFrot[2]=0.0;
    m_fFrot[3]=0.0;
    
    m_fVx=0.0;
    m_fVy=0.0;
    
    m_fVmaxX=600.0;
    m_fVmaxY=600.0;
    
    m_fRebond[0]=0.0;
    m_fRebond[1]=0.0;
    m_fRebond[2]=0.0;
    m_fRebond[3]=0.0;
    
    m_bBloque[0]=false;
    m_bBloque[1]=false;
    m_bBloque[2]=false;
    m_bBloque[3]=false;
    
    if (bBouge)
        m_pListeForces = new ListeChainee<Force>;
    else
        m_pListeForces = NULL;
    
}

PhysicData::~PhysicData()
{
    if (m_pListeForces!=NULL) delete m_pListeForces;
}

void PhysicData::ajouterForce(Force *pForce, char *szNom)
{
    if (m_pListeForces!=NULL)
        m_pListeForces->add(pForce,szNom);
}

void PhysicData::ajouterGravite()
{
    ajouterForce(new Force(0.0,10.0*9.8,-1),"Poids");
}

//si iDirection negatif retourne somme des forces Y negatives
//si iDirection positif retourne somme de forces positives
//si iDirection == 0 alors retourne la somme de toutes les forces
float PhysicData::getSommeForcesX(int iDirection)
{
    if (m_pListeForces==NULL)
        return 0.0;

    float fX=0.0;
    m_pListeForces->debut();
    for (int i=0; i<m_pListeForces->getSize() ; i++,m_pListeForces->suivant())
    {
        if ( (iDirection >0 && m_pListeForces->getCourant()->getX()>0)
            || (iDirection <0 && m_pListeForces->getCourant()->getX()<0) || iDirection==0)
            fX=fX+m_pListeForces->getCourant()->getX();
        
    }
    return fX;
}

//si iDirection negatif retourne somme des forces Y negatives
//si iDirection positif retourne somme de forces positives
//si iDirection == 0 alors retourne la somme de toutes les forces
float PhysicData::getSommeForcesY(int iDirection)
{
    if (m_pListeForces==NULL)
        return 0.0;

    float fY=0.0;
    m_pListeForces->debut();
    for (int i=0; i<m_pListeForces->getSize() ; i++,m_pListeForces->suivant())
    {
        if ( (iDirection >0 && m_pListeForces->getCourant()->getY()>0)
            || (iDirection <0 && m_pListeForces->getCourant()->getY()<0) || iDirection==0)
            fY=fY+m_pListeForces->getCourant()->getY();
        
    }
    return fY;
}

void PhysicData::enleverForces()
{
    if (m_pListeForces==NULL)
        return;
   
    bool fin=false;

    if (m_pListeForces->getSize()==0)
        return;
    
    m_pListeForces->debut();    
    while(!fin)
    {
        if (!m_pListeForces->getCourant()->valable())
        {
           m_pListeForces->delCourant();
           fin =(m_pListeForces->getSize()==0);
        }   
        else
            fin=!m_pListeForces->suivant();
    } 
}

float PhysicData::getVx(int iDirection)
{
    if ((iDirection<0 && m_fVx<0.0 )||(iDirection>0 && m_fVx>0.0) || (iDirection ==0))
        return m_fVx;
    else
        return 0.0;
}

float PhysicData::getVy(int iDirection)
{
    if ( (iDirection<0 && m_fVy<0.0 )||(iDirection>0 && m_fVy>0.0) || (iDirection ==0))
        return m_fVy;
    else
        return 0.0;
}

void PhysicData::setBouge(bool bBouge)
{
    if (bBouge)
    {
        if (m_pListeForces==NULL)
            m_pListeForces= new ListeChainee<Force>;
    }
    else
    {
        if (m_pListeForces!=NULL)
            delete m_pListeForces;    
    }
    m_bBouge=bBouge;
}


void PhysicData::debloquer()
{
    m_bBloque[0]=false;
    m_bBloque[1]=false;
    m_bBloque[2]=false;
    m_bBloque[3]=false;
}

bool PhysicData::arrete(int iDirection)
{
    switch (iDirection)
    {
        case DROITE :
        case GAUCHE : return (arreteX()); break;
        case HAUT :
        case BAS : return (arreteY()); break;
        default : return false;
    }
}

void PhysicData::setVy(float fVy)
{ 
    if (fVy<0 && fVy<-m_fVmaxY)
         m_fVy=-m_fVmaxY;
    else if(fVy>0 && fVy>m_fVmaxY)
        m_fVy=m_fVmaxY;
    else
         m_fVy=fVy;
}
        
void PhysicData::setVx(float fVx)
{ 
    if (fVx<0 && fVx<-m_fVmaxX)
         m_fVx=-m_fVmaxX;
    else if(fVx>0 && fVx>m_fVmaxX)
        m_fVx=m_fVmaxX;
    else
         m_fVx=fVx;
}

